 ; Ŀ
 ;   Fand - Text string and substring locator.                             
 ;   Copyright 1991, 1995, 1999, 2001 by Rocket Software                   
 ;   Who says text editors have all the fun?                               
 ; 

 ; Ŀ
 ;   Mark - mark a point.                                                  
 ;   Arguments: Pa - the point to mark.                                    
 ;              Rad - the marker segment length.                           
 ;              Colo - the marker grdraw line colour.                      
 ; 
 (DEFUN MARK (pa rad colo /)
  (grdraw (polar pa (/ pi 4) rad) (polar pa (* 1.25 pi) rad) colo)
  (grdraw (polar pa (* pi 0.75) rad) (polar pa (* pi 1.75) rad) colo)
 (princ))
 ; Ŀ
 ;   Mark end.                                                             
 ; 

 ; Ŀ
 ;   Sonar - see if a string contains a substring.                         
 ;   Arguments:  Loc, the substring.                                       
 ;               Txt, the string.                                          
 ;               Cas, if this is non-nil then the search                   
 ;                                is non-case-sensitive.                   
 ;   Returns the number of occurrences of the substring.                   
 ; 
 (DEFUN SONAR (loc txt cas / chflg ln sta st)
  (setq chflg 0)
  (if cas 
      (progn
           (setq loc (strcase loc t))
           (setq txt (strcase txt t))))
  (setq ln (strlen loc))
  (setq sta 1)
  (while (= ln (strlen (setq st (substr txt sta ln))))
         (if (= st loc) (setq chflg (1+ chflg)))
         (setq sta (1+ sta)))
 chflg)
 ; Ŀ
 ;   Sonar end.                                                            
 ; 

 ; Ŀ
 ;   Fand.                                                                 
 ; 
 (DEFUN C:FAND (/ rad nuftx numstr numats atsubn msent psent space enam ssav
                  cas ln losc prom loco ss lenx num entt typ str colo subs
                  espace nuf numvat invis numiat len esub inv suff sufi)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Size marker blips, initialize variables.                              
 ; 
  (setq rad (/ (getvar "viewsize") 20))
  (setq nuftx 0)   ; number of occurrences in text entities
  (setq numstr 0)  ; number of text entities with the substring
  (setq numats 0)  ; number of attdefs with the sub
  (setq atsubn 0)  ; total substrings in attdefs
  (setq msent 0)   ; total entities in model space (67 0)
  (setq psent 0)   ; total entities in paper space (67 1)
 ; Ŀ
 ;   See which space we are in.  The code (tblnext "vport" T) should       
 ;   provide information on this, but (at least on this system) it         
 ;   returns only nil.  (See also (vports) and the Cvport sysvar.)         
 ; 
  (command ".point" "0,0")
  (setq space (cdr (assoc 67 (entget (setq enam (entlast))))))
  (entdel enam)
 ; Ŀ
 ;   Make a new selection set to contain the entities with the substring.  
 ; 
  (setq ssav (ssadd))
 ; Ŀ
 ;   See if search is to be case sensitive.  Allow for some idiot          
 ;   entering the search string instead of answering the question.         
 ; 
  (setq cas (getstring t "Case sensitive search? <N>: "))
  (cond ((or (= cas "") (= cas "n") (= cas "N"))
         (setq ln 0)
         (setq cas T))
        ((or (= cas "y") (= cas "Y"))
         (setq ln 0)
         (setq cas ()))
        (T
         (setq loc cas)
         (setq ln (strlen cas))
         (setq cas T)
         (setq losc (strcat (strcase (substr loc 1 1)) (substr loc 2)))
         (write-line (strcat losc
                              " taken as non-case sensitive search string."))))
 ; Ŀ
 ;   If a search string wasn't entered at the Case prompt, ask for one.    
 ; 
  (if (/= (type loc) 'STR)
      (progn
           (setq loc "")
           (setq prom "String to locate: "))
      (setq prom (strcat "String to locate <" loc ">: ")))
  (while (= ln 0)
         (setq loco (getstring t prom))
         (if (/= loco "") (setq loc loco))
         (setq ln (strlen loc))
         (setq prom "You can't search for an empty string. Try again: "))
  (if cas (setq loc (strcase loc t)))
 ; Ŀ
 ;   Get a selection set of all the text and mtext in the drawing.         
 ; 
  (setq ss (ssget "x" '((-4 . "<or") (0 . "text") (0 . "mtext") (-4 . "or>"))))
 ; Ŀ
 ;   Make the length counter half-string.                                  
 ; 
  (if ss (setq lenx (strcat "/" (itoa (sslength ss))))
         (prompt "No text/mtext found."))
 ; Ŀ
 ;   While there are text entities in the selection set:                   
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq typ (cdr (assoc 0 entt)))
         (cond ((= typ "TEXT")
                (setq str (cdr (assoc 1 entt)))
                (setq colo 7))
               ((= typ "MTEXT")
                (setq str (cdr (assoc 1 entt)))
                (setq colo 3)))
         (grtext -2 (strcat (itoa num) lenx))
         (setq subs (sonar loc str cas))       ; call sonar to find substrings
         (if (> subs 0)
             (progn
                  (setq espace (cdr (assoc 67 entt)))
                  (if (= 1 espace)
                      (setq psent (1+ psent))         ; increment ps counter
                      (setq msent (1+ msent)))        ; or increment ms counter
                  (if (= space espace)
                      (mark (cdr (assoc 10 entt)) rad colo))
                  (ssadd enam ssav)                   ; save ename in new ss
                  (setq numstr (1+ numstr))           ; number of strings w sub
                  (setq nuftx (+ nuftx subs)))))      ; total subs in strings
 ; Ŀ
 ;   Get a selection set of all the attdefs in the drawing, make the       
 ;   length counter half-string, don't mention if there aren't any.        
 ; 
  (if (setq ss (ssget "x" '((0 . "attdef"))))
      (setq lenx (strcat "/" (itoa (sslength ss)))))
 ; Ŀ
 ;   While there are attdefs in the selection set:                         
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq entt (entget enam))
         (setq str (cdr (assoc 2 entt)))
         (grtext -2 (strcat (itoa num) lenx))
         (setq subs (sonar loc str cas)) ; call sonar to find substrings
         (if (> subs 0)
             (progn
                  (setq espace (cdr (assoc 67 entt)))
                  (if (= 1 espace)
                      (setq psent (1+ psent))         ; increment ps counter
                      (setq msent (1+ msent)))        ; or increment ms counter
                  (if (= space espace)
                      (mark (cdr (assoc 10 entt)) rad 2))
                  (ssadd enam ssav)                   ; save ename in new ss
                  (setq numats (1+ numats))           ; number of attdefs w sub
                  (setq atsubn (+ atsubn subs)))))    ; total subs in attdefs
 ; Ŀ
 ;                                                                         
 ;   Now search for the same string in attributes.                         
 ;                                                                         
 ; 
  (setq nuf 0)    ; strings found in vis. attributes
  (setq numvat 0) ; vis attributes found (may be several strings/attribute)
  (setq invis 0)  ; strings found in invisible attributes
  (setq numiat 0) ; invis attributes found
 ; Ŀ
 ;   Get selection set of blocks with attributes, make the length counter  
 ;   half-string or mention that there are no blocks can use.              
 ; 
  (if (setq ss (ssget "X" (list (cons 66 1) (cons 0 "INSERT"))))
      (setq len (strcat "/" (itoa (sslength ss))))
      (prompt "No attributed bocks found."))
 ; Ŀ
 ;   Check each block in the ss.                                           
 ; 
  (setq num 0)
  (while (and ss (setq enam (ssname ss num)))
         (setq num (1+ num))
         (setq esub (entnext enam))
         (grtext -2 (strcat (itoa num) len))
         (while (/= "SEQEND" (cdr (assoc 0 (setq entt (entget esub)))))
                (setq str (cdr (assoc 1 entt)))
                (setq inv (= 1 (logand 1 (cdr (assoc 70 entt)))))  ; invisible?
                (setq subs (sonar loc str cas)) ; call sonar to find substrings
                (if (> subs 0)                  ; if substring was found
                    (progn
                         (setq espace (cdr (assoc 67 entt)))
                         (if (= 1 espace)
                             (setq psent (1+ psent))  ; increment ps counter
                             (setq msent (1+ msent))) ; or increment ms counter
                         (ssadd enam ssav)))          ; add entity to ss
                (cond ((and inv (> subs 0))
                       (setq invis (+ subs invis))
                       (setq numiat (1+ numiat))
                       (if (= space espace)
                           (mark (cdr (assoc 10 entt)) rad 4)))
                      ((> subs 0)
                       (setq nuf (+ subs nuf))
                       (setq numvat (1+ numvat))
                       (if (= space espace)
                           (mark (cdr (assoc 10 entt)) rad 1))))
                (setq esub (entnext esub))))
 ; Ŀ
 ;   Sum up and end.                                                       
 ; 
  (if (> nuftx 0)
      (progn
           (setq suff (if (> nuftx 1) "s" ""))
           (setq sufi (if (> numstr 1) "ies" "y"))
           (prompt (strcat (itoa nuftx) " occurrence" suff " in "
                           (itoa numstr)
                           " text (white X) "
                           (if (> numstr 1) "and" "or")
                           " mtext (green X) entit"
                           sufi "." ))))
  (if (> nuf 0)
      (progn
           (setq suff (if (> nuf 1) "s" ""))
           (setq sufi (if (> numvat 1) "s" ""))
           (prompt (strcat "\n" (itoa nuf) " occurrence" suff
                           " in " (itoa numvat) " visible attribute" sufi
                           " (red X)."))))
  (if (> invis 0)
      (progn
           (setq suff (if (> invis 1) "s" ""))
           (setq sufi (if (> numiat 1) "s" ""))
           (prompt (strcat "\n" (itoa invis) " occurrence" suff
                           " in " (itoa numiat) " invisible attribute" sufi
                           " (cyan X)."))))
  (if (> numats 0)
      (progn
           (setq suff (if (> numats 1) "s" ""))
           (setq sufi (if (> atsubn 1) "s" ""))
           (prompt (strcat "\n" (itoa atsubn) " occurrence" suff
                           " in " (itoa numats)
                           " loose attdef" sufi " (yellow X)."))))
  (if (and (= nuftx 0) (= nuf 0) (= invis 0) (= numats 0))
      (prompt "\nNo occurrences found."))
 ; Ŀ
 ;   List entities found in each space only if some are in the other one.  
 ; 
  (cond ((and (= space 1) (> msent 0))
         (write-line (strcat "\n(" (itoa msent)
                             " entit" (if (= msent 1) "y" "ies")
                             " in model space "
                             (if (= msent 1) "was" "were")
                             " not marked.)")))
        ((and (= space 0) (> psent 0))
         (write-line (strcat "\n(" (itoa psent)
                             " entit" (if (= psent 1) "y" "ies")
                             " in paper space "
                             (if (= psent 1) "was" "were")
                             " not marked.)"))))
 ; Ŀ
 ;   Set the Previous ss to the ss of everything with the search string.   
 ; 
  (command ".select" ssav "")
 (princ))